package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.RetryTask;
import com.xforceplus.ultraman.app.arterydocument.service.IRetryTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-25
 */
@RestController
public class RetryTaskController {

  @Autowired
  private IRetryTaskService retryTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param retryTask ${table.comment}
   * @return
   */
  @GetMapping("/retrytasks" )
  public XfR getRetryTasks(XfPage page, RetryTask retryTask) {
    return XfR.ok(retryTaskServiceImpl.page(page, Wrappers.query(retryTask)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/retrytasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(retryTaskServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param retryTask ${table.comment}
   * @return XfR
   */
  @PostMapping("/retrytasks")
  public XfR save(@RequestBody RetryTask retryTask) {
     return XfR.ok(retryTaskServiceImpl.save(retryTask));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param retryTask ${table.comment}
   * @return XfR
   */
  @PutMapping("/retrytasks/{id}")
  public XfR putUpdate(@RequestBody RetryTask retryTask,@PathVariable Long id) {
      retryTask.setId(id);
      return XfR.ok(retryTaskServiceImpl.updateById(retryTask));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param retryTask ${table.comment}
   * @return XfR
   */
  @PatchMapping("/retrytasks/{id}")
  public XfR patchUpdate(@RequestBody RetryTask retryTask,@PathVariable Long id) {
      RetryTask upretryTask = retryTaskServiceImpl.getById(id);
      if(upretryTask != null){
        upretryTask = ObjectCopyUtils.copyProperties(retryTask,upretryTask,true);
      }
      return XfR.ok(retryTaskServiceImpl.updateById(upretryTask));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/retrytasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(retryTaskServiceImpl.removeById(id));
  }

  @PostMapping("/retrytasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "retry_task");
     params.put("request", condition);

     return XfR.ok(retryTaskServiceImpl.querys(params));
  }

}
