package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.SettlementDocRefInvoice;
import com.xforceplus.ultraman.app.arterydocument.service.ISettlementDocRefInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * V2前端控制器
 *
 * @author ultraman
 * @date 2024-07-25
 */
@RestController
public class SettlementDocRefInvoiceController {

  @Autowired
  private ISettlementDocRefInvoiceService settlementDocRefInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementDocRefInvoice V2
   * @return
   */
  @GetMapping("/settlementdocrefinvoices" )
  public XfR getSettlementDocRefInvoices(XfPage page, SettlementDocRefInvoice settlementDocRefInvoice) {
    return XfR.ok(settlementDocRefInvoiceServiceImpl.page(page, Wrappers.query(settlementDocRefInvoice)));
  }

  /**
   * 通过id查询V2
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementdocrefinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementDocRefInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增V2
   * @param settlementDocRefInvoice V2
   * @return XfR
   */
  @PostMapping("/settlementdocrefinvoices")
  public XfR save(@RequestBody SettlementDocRefInvoice settlementDocRefInvoice) {
     return XfR.ok(settlementDocRefInvoiceServiceImpl.save(settlementDocRefInvoice));
  }

  /**
   * 修改-传入修改后的全部数据V2
   * @param settlementDocRefInvoice V2
   * @return XfR
   */
  @PutMapping("/settlementdocrefinvoices/{id}")
  public XfR putUpdate(@RequestBody SettlementDocRefInvoice settlementDocRefInvoice,@PathVariable Long id) {
      settlementDocRefInvoice.setId(id);
      return XfR.ok(settlementDocRefInvoiceServiceImpl.updateById(settlementDocRefInvoice));
  }

  /**
   * 修改-传入修改的数据V2
   * @param settlementDocRefInvoice V2
   * @return XfR
   */
  @PatchMapping("/settlementdocrefinvoices/{id}")
  public XfR patchUpdate(@RequestBody SettlementDocRefInvoice settlementDocRefInvoice,@PathVariable Long id) {
      SettlementDocRefInvoice upsettlementDocRefInvoice = settlementDocRefInvoiceServiceImpl.getById(id);
      if(upsettlementDocRefInvoice != null){
        upsettlementDocRefInvoice = ObjectCopyUtils.copyProperties(settlementDocRefInvoice,upsettlementDocRefInvoice,true);
      }
      return XfR.ok(settlementDocRefInvoiceServiceImpl.updateById(upsettlementDocRefInvoice));
  }

  /**
   * 通过id删除V2
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementdocrefinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementDocRefInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/settlementdocrefinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_doc_ref_invoice");
     params.put("request", condition);

     return XfR.ok(settlementDocRefInvoiceServiceImpl.querys(params));
  }

}
