package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.SuggestPrice;
import com.xforceplus.ultraman.app.arterydocument.service.ISuggestPriceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-25
 */
@RestController
public class SuggestPriceController {

  @Autowired
  private ISuggestPriceService suggestPriceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param suggestPrice ${table.comment}
   * @return
   */
  @GetMapping("/suggestprices" )
  public XfR getSuggestPrices(XfPage page, SuggestPrice suggestPrice) {
    return XfR.ok(suggestPriceServiceImpl.page(page, Wrappers.query(suggestPrice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/suggestprices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(suggestPriceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param suggestPrice ${table.comment}
   * @return XfR
   */
  @PostMapping("/suggestprices")
  public XfR save(@RequestBody SuggestPrice suggestPrice) {
     return XfR.ok(suggestPriceServiceImpl.save(suggestPrice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param suggestPrice ${table.comment}
   * @return XfR
   */
  @PutMapping("/suggestprices/{id}")
  public XfR putUpdate(@RequestBody SuggestPrice suggestPrice,@PathVariable Long id) {
      suggestPrice.setId(id);
      return XfR.ok(suggestPriceServiceImpl.updateById(suggestPrice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param suggestPrice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/suggestprices/{id}")
  public XfR patchUpdate(@RequestBody SuggestPrice suggestPrice,@PathVariable Long id) {
      SuggestPrice upsuggestPrice = suggestPriceServiceImpl.getById(id);
      if(upsuggestPrice != null){
        upsuggestPrice = ObjectCopyUtils.copyProperties(suggestPrice,upsuggestPrice,true);
      }
      return XfR.ok(suggestPriceServiceImpl.updateById(upsuggestPrice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/suggestprices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(suggestPriceServiceImpl.removeById(id));
  }

  @PostMapping("/suggestprices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "suggest_price");
     params.put("request", condition);

     return XfR.ok(suggestPriceServiceImpl.querys(params));
  }

}
