package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.WalmartPO;
import com.xforceplus.ultraman.app.arterydocument.service.IWalmartPOService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-25
 */
@RestController
public class WalmartPOController {

  @Autowired
  private IWalmartPOService walmartPOServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param walmartPO ${table.comment}
   * @return
   */
  @GetMapping("/walmartpos" )
  public XfR getWalmartPOs(XfPage page, WalmartPO walmartPO) {
    return XfR.ok(walmartPOServiceImpl.page(page, Wrappers.query(walmartPO)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/walmartpos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(walmartPOServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param walmartPO ${table.comment}
   * @return XfR
   */
  @PostMapping("/walmartpos")
  public XfR save(@RequestBody WalmartPO walmartPO) {
     return XfR.ok(walmartPOServiceImpl.save(walmartPO));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param walmartPO ${table.comment}
   * @return XfR
   */
  @PutMapping("/walmartpos/{id}")
  public XfR putUpdate(@RequestBody WalmartPO walmartPO,@PathVariable Long id) {
      walmartPO.setId(id);
      return XfR.ok(walmartPOServiceImpl.updateById(walmartPO));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param walmartPO ${table.comment}
   * @return XfR
   */
  @PatchMapping("/walmartpos/{id}")
  public XfR patchUpdate(@RequestBody WalmartPO walmartPO,@PathVariable Long id) {
      WalmartPO upwalmartPO = walmartPOServiceImpl.getById(id);
      if(upwalmartPO != null){
        upwalmartPO = ObjectCopyUtils.copyProperties(walmartPO,upwalmartPO,true);
      }
      return XfR.ok(walmartPOServiceImpl.updateById(upwalmartPO));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/walmartpos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(walmartPOServiceImpl.removeById(id));
  }

  @PostMapping("/walmartpos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "walmart_p_o");
     params.put("request", condition);

     return XfR.ok(walmartPOServiceImpl.querys(params));
  }

}
