package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.BillingNoInvoiceRecord;
import com.xforceplus.ultraman.app.arterydocument.service.IBillingNoInvoiceRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-04
 */
@RestController
public class BillingNoInvoiceRecordController {

  @Autowired
  private IBillingNoInvoiceRecordService billingNoInvoiceRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billingNoInvoiceRecord ${table.comment}
   * @return
   */
  @GetMapping("/billingnoinvoicerecords" )
  public XfR getBillingNoInvoiceRecords(XfPage page, BillingNoInvoiceRecord billingNoInvoiceRecord) {
    return XfR.ok(billingNoInvoiceRecordServiceImpl.page(page, Wrappers.query(billingNoInvoiceRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billingnoinvoicerecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billingNoInvoiceRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billingNoInvoiceRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/billingnoinvoicerecords")
  public XfR save(@RequestBody BillingNoInvoiceRecord billingNoInvoiceRecord) {
     return XfR.ok(billingNoInvoiceRecordServiceImpl.save(billingNoInvoiceRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billingNoInvoiceRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/billingnoinvoicerecords/{id}")
  public XfR putUpdate(@RequestBody BillingNoInvoiceRecord billingNoInvoiceRecord,@PathVariable Long id) {
      billingNoInvoiceRecord.setId(id);
      return XfR.ok(billingNoInvoiceRecordServiceImpl.updateById(billingNoInvoiceRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billingNoInvoiceRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billingnoinvoicerecords/{id}")
  public XfR patchUpdate(@RequestBody BillingNoInvoiceRecord billingNoInvoiceRecord,@PathVariable Long id) {
      BillingNoInvoiceRecord upbillingNoInvoiceRecord = billingNoInvoiceRecordServiceImpl.getById(id);
      if(upbillingNoInvoiceRecord != null){
        upbillingNoInvoiceRecord = ObjectCopyUtils.copyProperties(billingNoInvoiceRecord,upbillingNoInvoiceRecord,true);
      }
      return XfR.ok(billingNoInvoiceRecordServiceImpl.updateById(upbillingNoInvoiceRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billingnoinvoicerecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billingNoInvoiceRecordServiceImpl.removeById(id));
  }

  @PostMapping("/billingnoinvoicerecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "billing_no_invoice_record");
     params.put("request", condition);

     return XfR.ok(billingNoInvoiceRecordServiceImpl.querys(params));
  }

}
