package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.DocumentSendControl;
import com.xforceplus.ultraman.app.arterydocument.service.IDocumentSendControlService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-04
 */
@RestController
public class DocumentSendControlController {

  @Autowired
  private IDocumentSendControlService documentSendControlServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param documentSendControl ${table.comment}
   * @return
   */
  @GetMapping("/documentsendcontrols" )
  public XfR getDocumentSendControls(XfPage page, DocumentSendControl documentSendControl) {
    return XfR.ok(documentSendControlServiceImpl.page(page, Wrappers.query(documentSendControl)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/documentsendcontrols/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(documentSendControlServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param documentSendControl ${table.comment}
   * @return XfR
   */
  @PostMapping("/documentsendcontrols")
  public XfR save(@RequestBody DocumentSendControl documentSendControl) {
     return XfR.ok(documentSendControlServiceImpl.save(documentSendControl));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param documentSendControl ${table.comment}
   * @return XfR
   */
  @PutMapping("/documentsendcontrols/{id}")
  public XfR putUpdate(@RequestBody DocumentSendControl documentSendControl,@PathVariable Long id) {
      documentSendControl.setId(id);
      return XfR.ok(documentSendControlServiceImpl.updateById(documentSendControl));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param documentSendControl ${table.comment}
   * @return XfR
   */
  @PatchMapping("/documentsendcontrols/{id}")
  public XfR patchUpdate(@RequestBody DocumentSendControl documentSendControl,@PathVariable Long id) {
      DocumentSendControl updocumentSendControl = documentSendControlServiceImpl.getById(id);
      if(updocumentSendControl != null){
        updocumentSendControl = ObjectCopyUtils.copyProperties(documentSendControl,updocumentSendControl,true);
      }
      return XfR.ok(documentSendControlServiceImpl.updateById(updocumentSendControl));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/documentsendcontrols/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(documentSendControlServiceImpl.removeById(id));
  }

  @PostMapping("/documentsendcontrols/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "document_send_control");
     params.put("request", condition);

     return XfR.ok(documentSendControlServiceImpl.querys(params));
  }

}
