package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.DocumentUnsendRecord;
import com.xforceplus.ultraman.app.arterydocument.service.IDocumentUnsendRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-04
 */
@RestController
public class DocumentUnsendRecordController {

  @Autowired
  private IDocumentUnsendRecordService documentUnsendRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param documentUnsendRecord ${table.comment}
   * @return
   */
  @GetMapping("/documentunsendrecords" )
  public XfR getDocumentUnsendRecords(XfPage page, DocumentUnsendRecord documentUnsendRecord) {
    return XfR.ok(documentUnsendRecordServiceImpl.page(page, Wrappers.query(documentUnsendRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/documentunsendrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(documentUnsendRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param documentUnsendRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/documentunsendrecords")
  public XfR save(@RequestBody DocumentUnsendRecord documentUnsendRecord) {
     return XfR.ok(documentUnsendRecordServiceImpl.save(documentUnsendRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param documentUnsendRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/documentunsendrecords/{id}")
  public XfR putUpdate(@RequestBody DocumentUnsendRecord documentUnsendRecord,@PathVariable Long id) {
      documentUnsendRecord.setId(id);
      return XfR.ok(documentUnsendRecordServiceImpl.updateById(documentUnsendRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param documentUnsendRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/documentunsendrecords/{id}")
  public XfR patchUpdate(@RequestBody DocumentUnsendRecord documentUnsendRecord,@PathVariable Long id) {
      DocumentUnsendRecord updocumentUnsendRecord = documentUnsendRecordServiceImpl.getById(id);
      if(updocumentUnsendRecord != null){
        updocumentUnsendRecord = ObjectCopyUtils.copyProperties(documentUnsendRecord,updocumentUnsendRecord,true);
      }
      return XfR.ok(documentUnsendRecordServiceImpl.updateById(updocumentUnsendRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/documentunsendrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(documentUnsendRecordServiceImpl.removeById(id));
  }

  @PostMapping("/documentunsendrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "document_unsend_record");
     params.put("request", condition);

     return XfR.ok(documentUnsendRecordServiceImpl.querys(params));
  }

}
