package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.FinanceReturnToVendorDetail;
import com.xforceplus.ultraman.app.arterydocument.service.IFinanceReturnToVendorDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-04
 */
@RestController
public class FinanceReturnToVendorDetailController {

  @Autowired
  private IFinanceReturnToVendorDetailService financeReturnToVendorDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financeReturnToVendorDetail ${table.comment}
   * @return
   */
  @GetMapping("/financereturntovendordetails" )
  public XfR getFinanceReturnToVendorDetails(XfPage page, FinanceReturnToVendorDetail financeReturnToVendorDetail) {
    return XfR.ok(financeReturnToVendorDetailServiceImpl.page(page, Wrappers.query(financeReturnToVendorDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financereturntovendordetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financeReturnToVendorDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financeReturnToVendorDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/financereturntovendordetails")
  public XfR save(@RequestBody FinanceReturnToVendorDetail financeReturnToVendorDetail) {
     return XfR.ok(financeReturnToVendorDetailServiceImpl.save(financeReturnToVendorDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financeReturnToVendorDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/financereturntovendordetails/{id}")
  public XfR putUpdate(@RequestBody FinanceReturnToVendorDetail financeReturnToVendorDetail,@PathVariable Long id) {
      financeReturnToVendorDetail.setId(id);
      return XfR.ok(financeReturnToVendorDetailServiceImpl.updateById(financeReturnToVendorDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financeReturnToVendorDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financereturntovendordetails/{id}")
  public XfR patchUpdate(@RequestBody FinanceReturnToVendorDetail financeReturnToVendorDetail,@PathVariable Long id) {
      FinanceReturnToVendorDetail upfinanceReturnToVendorDetail = financeReturnToVendorDetailServiceImpl.getById(id);
      if(upfinanceReturnToVendorDetail != null){
        upfinanceReturnToVendorDetail = ObjectCopyUtils.copyProperties(financeReturnToVendorDetail,upfinanceReturnToVendorDetail,true);
      }
      return XfR.ok(financeReturnToVendorDetailServiceImpl.updateById(upfinanceReturnToVendorDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financereturntovendordetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financeReturnToVendorDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financereturntovendordetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "finance_return_to_vendor_detail");
     params.put("request", condition);

     return XfR.ok(financeReturnToVendorDetailServiceImpl.querys(params));
  }

}
