package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.MarketAccountConfig;
import com.xforceplus.ultraman.app.arterydocument.service.IMarketAccountConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-04
 */
@RestController
public class MarketAccountConfigController {

  @Autowired
  private IMarketAccountConfigService marketAccountConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param marketAccountConfig ${table.comment}
   * @return
   */
  @GetMapping("/marketaccountconfigs" )
  public XfR getMarketAccountConfigs(XfPage page, MarketAccountConfig marketAccountConfig) {
    return XfR.ok(marketAccountConfigServiceImpl.page(page, Wrappers.query(marketAccountConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/marketaccountconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(marketAccountConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param marketAccountConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/marketaccountconfigs")
  public XfR save(@RequestBody MarketAccountConfig marketAccountConfig) {
     return XfR.ok(marketAccountConfigServiceImpl.save(marketAccountConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param marketAccountConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/marketaccountconfigs/{id}")
  public XfR putUpdate(@RequestBody MarketAccountConfig marketAccountConfig,@PathVariable Long id) {
      marketAccountConfig.setId(id);
      return XfR.ok(marketAccountConfigServiceImpl.updateById(marketAccountConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param marketAccountConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/marketaccountconfigs/{id}")
  public XfR patchUpdate(@RequestBody MarketAccountConfig marketAccountConfig,@PathVariable Long id) {
      MarketAccountConfig upmarketAccountConfig = marketAccountConfigServiceImpl.getById(id);
      if(upmarketAccountConfig != null){
        upmarketAccountConfig = ObjectCopyUtils.copyProperties(marketAccountConfig,upmarketAccountConfig,true);
      }
      return XfR.ok(marketAccountConfigServiceImpl.updateById(upmarketAccountConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/marketaccountconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(marketAccountConfigServiceImpl.removeById(id));
  }

  @PostMapping("/marketaccountconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "market_account_config");
     params.put("request", condition);

     return XfR.ok(marketAccountConfigServiceImpl.querys(params));
  }

}
