package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.RdnModuleConfig;
import com.xforceplus.ultraman.app.arterydocument.service.IRdnModuleConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-04
 */
@RestController
public class RdnModuleConfigController {

  @Autowired
  private IRdnModuleConfigService rdnModuleConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param rdnModuleConfig ${table.comment}
   * @return
   */
  @GetMapping("/rdnmoduleconfigs" )
  public XfR getRdnModuleConfigs(XfPage page, RdnModuleConfig rdnModuleConfig) {
    return XfR.ok(rdnModuleConfigServiceImpl.page(page, Wrappers.query(rdnModuleConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/rdnmoduleconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(rdnModuleConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param rdnModuleConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/rdnmoduleconfigs")
  public XfR save(@RequestBody RdnModuleConfig rdnModuleConfig) {
     return XfR.ok(rdnModuleConfigServiceImpl.save(rdnModuleConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param rdnModuleConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/rdnmoduleconfigs/{id}")
  public XfR putUpdate(@RequestBody RdnModuleConfig rdnModuleConfig,@PathVariable Long id) {
      rdnModuleConfig.setId(id);
      return XfR.ok(rdnModuleConfigServiceImpl.updateById(rdnModuleConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param rdnModuleConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/rdnmoduleconfigs/{id}")
  public XfR patchUpdate(@RequestBody RdnModuleConfig rdnModuleConfig,@PathVariable Long id) {
      RdnModuleConfig uprdnModuleConfig = rdnModuleConfigServiceImpl.getById(id);
      if(uprdnModuleConfig != null){
        uprdnModuleConfig = ObjectCopyUtils.copyProperties(rdnModuleConfig,uprdnModuleConfig,true);
      }
      return XfR.ok(rdnModuleConfigServiceImpl.updateById(uprdnModuleConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/rdnmoduleconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(rdnModuleConfigServiceImpl.removeById(id));
  }

  @PostMapping("/rdnmoduleconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "rdn_module_config");
     params.put("request", condition);

     return XfR.ok(rdnModuleConfigServiceImpl.querys(params));
  }

}
