package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.TenantSalesOrder;
import com.xforceplus.ultraman.app.arterydocument.service.ITenantSalesOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-04
 */
@RestController
public class TenantSalesOrderController {

  @Autowired
  private ITenantSalesOrderService tenantSalesOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tenantSalesOrder ${table.comment}
   * @return
   */
  @GetMapping("/tenantsalesorders" )
  public XfR getTenantSalesOrders(XfPage page, TenantSalesOrder tenantSalesOrder) {
    return XfR.ok(tenantSalesOrderServiceImpl.page(page, Wrappers.query(tenantSalesOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tenantsalesorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tenantSalesOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tenantSalesOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/tenantsalesorders")
  public XfR save(@RequestBody TenantSalesOrder tenantSalesOrder) {
     return XfR.ok(tenantSalesOrderServiceImpl.save(tenantSalesOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tenantSalesOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/tenantsalesorders/{id}")
  public XfR putUpdate(@RequestBody TenantSalesOrder tenantSalesOrder,@PathVariable Long id) {
      tenantSalesOrder.setId(id);
      return XfR.ok(tenantSalesOrderServiceImpl.updateById(tenantSalesOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tenantSalesOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tenantsalesorders/{id}")
  public XfR patchUpdate(@RequestBody TenantSalesOrder tenantSalesOrder,@PathVariable Long id) {
      TenantSalesOrder uptenantSalesOrder = tenantSalesOrderServiceImpl.getById(id);
      if(uptenantSalesOrder != null){
        uptenantSalesOrder = ObjectCopyUtils.copyProperties(tenantSalesOrder,uptenantSalesOrder,true);
      }
      return XfR.ok(tenantSalesOrderServiceImpl.updateById(uptenantSalesOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tenantsalesorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tenantSalesOrderServiceImpl.removeById(id));
  }

  @PostMapping("/tenantsalesorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tenant_sales_order");
     params.put("request", condition);

     return XfR.ok(tenantSalesOrderServiceImpl.querys(params));
  }

}
