package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.MiscPageConfig;
import com.xforceplus.ultraman.app.arterydocument.service.IMiscPageConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-21
 */
@RestController
public class MiscPageConfigController {

  @Autowired
  private IMiscPageConfigService miscPageConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param miscPageConfig ${table.comment}
   * @return
   */
  @GetMapping("/miscpageconfigs" )
  public XfR getMiscPageConfigs(XfPage page, MiscPageConfig miscPageConfig) {
    return XfR.ok(miscPageConfigServiceImpl.page(page, Wrappers.query(miscPageConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/miscpageconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(miscPageConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param miscPageConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/miscpageconfigs")
  public XfR save(@RequestBody MiscPageConfig miscPageConfig) {
     return XfR.ok(miscPageConfigServiceImpl.save(miscPageConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param miscPageConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/miscpageconfigs/{id}")
  public XfR putUpdate(@RequestBody MiscPageConfig miscPageConfig,@PathVariable Long id) {
      miscPageConfig.setId(id);
      return XfR.ok(miscPageConfigServiceImpl.updateById(miscPageConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param miscPageConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/miscpageconfigs/{id}")
  public XfR patchUpdate(@RequestBody MiscPageConfig miscPageConfig,@PathVariable Long id) {
      MiscPageConfig upmiscPageConfig = miscPageConfigServiceImpl.getById(id);
      if(upmiscPageConfig != null){
        upmiscPageConfig = ObjectCopyUtils.copyProperties(miscPageConfig,upmiscPageConfig,true);
      }
      return XfR.ok(miscPageConfigServiceImpl.updateById(upmiscPageConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/miscpageconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(miscPageConfigServiceImpl.removeById(id));
  }

  @PostMapping("/miscpageconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "misc_page_config");
     params.put("request", condition);

     return XfR.ok(miscPageConfigServiceImpl.querys(params));
  }

}
