package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.VoucherDetail;
import com.xforceplus.ultraman.app.arterydocument.service.IVoucherDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-21
 */
@RestController
public class VoucherDetailController {

  @Autowired
  private IVoucherDetailService voucherDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param voucherDetail ${table.comment}
   * @return
   */
  @GetMapping("/voucherdetails" )
  public XfR getVoucherDetails(XfPage page, VoucherDetail voucherDetail) {
    return XfR.ok(voucherDetailServiceImpl.page(page, Wrappers.query(voucherDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/voucherdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(voucherDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param voucherDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/voucherdetails")
  public XfR save(@RequestBody VoucherDetail voucherDetail) {
     return XfR.ok(voucherDetailServiceImpl.save(voucherDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param voucherDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/voucherdetails/{id}")
  public XfR putUpdate(@RequestBody VoucherDetail voucherDetail,@PathVariable Long id) {
      voucherDetail.setId(id);
      return XfR.ok(voucherDetailServiceImpl.updateById(voucherDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param voucherDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/voucherdetails/{id}")
  public XfR patchUpdate(@RequestBody VoucherDetail voucherDetail,@PathVariable Long id) {
      VoucherDetail upvoucherDetail = voucherDetailServiceImpl.getById(id);
      if(upvoucherDetail != null){
        upvoucherDetail = ObjectCopyUtils.copyProperties(voucherDetail,upvoucherDetail,true);
      }
      return XfR.ok(voucherDetailServiceImpl.updateById(upvoucherDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/voucherdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(voucherDetailServiceImpl.removeById(id));
  }

  @PostMapping("/voucherdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "voucher_detail");
     params.put("request", condition);

     return XfR.ok(voucherDetailServiceImpl.querys(params));
  }

}
