package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.AddressDemo;
import com.xforceplus.ultraman.app.arterydocument.service.IAddressDemoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-24
 */
@RestController
public class AddressDemoController {

  @Autowired
  private IAddressDemoService addressDemoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param addressDemo ${table.comment}
   * @return
   */
  @GetMapping("/addressdemos" )
  public XfR getAddressDemos(XfPage page, AddressDemo addressDemo) {
    return XfR.ok(addressDemoServiceImpl.page(page, Wrappers.query(addressDemo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/addressdemos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(addressDemoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param addressDemo ${table.comment}
   * @return XfR
   */
  @PostMapping("/addressdemos")
  public XfR save(@RequestBody AddressDemo addressDemo) {
     return XfR.ok(addressDemoServiceImpl.save(addressDemo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param addressDemo ${table.comment}
   * @return XfR
   */
  @PutMapping("/addressdemos/{id}")
  public XfR putUpdate(@RequestBody AddressDemo addressDemo,@PathVariable Long id) {
      addressDemo.setId(id);
      return XfR.ok(addressDemoServiceImpl.updateById(addressDemo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param addressDemo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/addressdemos/{id}")
  public XfR patchUpdate(@RequestBody AddressDemo addressDemo,@PathVariable Long id) {
      AddressDemo upaddressDemo = addressDemoServiceImpl.getById(id);
      if(upaddressDemo != null){
        upaddressDemo = ObjectCopyUtils.copyProperties(addressDemo,upaddressDemo,true);
      }
      return XfR.ok(addressDemoServiceImpl.updateById(upaddressDemo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/addressdemos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(addressDemoServiceImpl.removeById(id));
  }

  @PostMapping("/addressdemos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "address_demo");
     params.put("request", condition);

     return XfR.ok(addressDemoServiceImpl.querys(params));
  }

}
