package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.BusinessFlowRule;
import com.xforceplus.ultraman.app.arterydocument.service.IBusinessFlowRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-24
 */
@RestController
public class BusinessFlowRuleController {

  @Autowired
  private IBusinessFlowRuleService businessFlowRuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param businessFlowRule ${table.comment}
   * @return
   */
  @GetMapping("/businessflowrules" )
  public XfR getBusinessFlowRules(XfPage page, BusinessFlowRule businessFlowRule) {
    return XfR.ok(businessFlowRuleServiceImpl.page(page, Wrappers.query(businessFlowRule)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/businessflowrules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(businessFlowRuleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param businessFlowRule ${table.comment}
   * @return XfR
   */
  @PostMapping("/businessflowrules")
  public XfR save(@RequestBody BusinessFlowRule businessFlowRule) {
     return XfR.ok(businessFlowRuleServiceImpl.save(businessFlowRule));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param businessFlowRule ${table.comment}
   * @return XfR
   */
  @PutMapping("/businessflowrules/{id}")
  public XfR putUpdate(@RequestBody BusinessFlowRule businessFlowRule,@PathVariable Long id) {
      businessFlowRule.setId(id);
      return XfR.ok(businessFlowRuleServiceImpl.updateById(businessFlowRule));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param businessFlowRule ${table.comment}
   * @return XfR
   */
  @PatchMapping("/businessflowrules/{id}")
  public XfR patchUpdate(@RequestBody BusinessFlowRule businessFlowRule,@PathVariable Long id) {
      BusinessFlowRule upbusinessFlowRule = businessFlowRuleServiceImpl.getById(id);
      if(upbusinessFlowRule != null){
        upbusinessFlowRule = ObjectCopyUtils.copyProperties(businessFlowRule,upbusinessFlowRule,true);
      }
      return XfR.ok(businessFlowRuleServiceImpl.updateById(upbusinessFlowRule));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/businessflowrules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(businessFlowRuleServiceImpl.removeById(id));
  }

  @PostMapping("/businessflowrules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "business_flow_rule");
     params.put("request", condition);

     return XfR.ok(businessFlowRuleServiceImpl.querys(params));
  }

}
