package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.ExpenseSettlementDetail;
import com.xforceplus.ultraman.app.arterydocument.service.IExpenseSettlementDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-28
 */
@RestController
public class ExpenseSettlementDetailController {

  @Autowired
  private IExpenseSettlementDetailService expenseSettlementDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param expenseSettlementDetail ${table.comment}
   * @return
   */
  @GetMapping("/expensesettlementdetails" )
  public XfR getExpenseSettlementDetails(XfPage page, ExpenseSettlementDetail expenseSettlementDetail) {
    return XfR.ok(expenseSettlementDetailServiceImpl.page(page, Wrappers.query(expenseSettlementDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/expensesettlementdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(expenseSettlementDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param expenseSettlementDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/expensesettlementdetails")
  public XfR save(@RequestBody ExpenseSettlementDetail expenseSettlementDetail) {
     return XfR.ok(expenseSettlementDetailServiceImpl.save(expenseSettlementDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param expenseSettlementDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/expensesettlementdetails/{id}")
  public XfR putUpdate(@RequestBody ExpenseSettlementDetail expenseSettlementDetail,@PathVariable Long id) {
      expenseSettlementDetail.setId(id);
      return XfR.ok(expenseSettlementDetailServiceImpl.updateById(expenseSettlementDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param expenseSettlementDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/expensesettlementdetails/{id}")
  public XfR patchUpdate(@RequestBody ExpenseSettlementDetail expenseSettlementDetail,@PathVariable Long id) {
      ExpenseSettlementDetail upexpenseSettlementDetail = expenseSettlementDetailServiceImpl.getById(id);
      if(upexpenseSettlementDetail != null){
        upexpenseSettlementDetail = ObjectCopyUtils.copyProperties(expenseSettlementDetail,upexpenseSettlementDetail,true);
      }
      return XfR.ok(expenseSettlementDetailServiceImpl.updateById(upexpenseSettlementDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/expensesettlementdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(expenseSettlementDetailServiceImpl.removeById(id));
  }

  @PostMapping("/expensesettlementdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "expense_settlement_detail");
     params.put("request", condition);

     return XfR.ok(expenseSettlementDetailServiceImpl.querys(params));
  }

}
