package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.FlowReplayLog;
import com.xforceplus.ultraman.app.arterydocument.service.IFlowReplayLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 流程回放日志前端控制器
 *
 * @author ultraman
 * @date 2023-12-28
 */
@RestController
public class FlowReplayLogController {

  @Autowired
  private IFlowReplayLogService flowReplayLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param flowReplayLog 流程回放日志
   * @return
   */
  @GetMapping("/flowreplaylogs" )
  public XfR getFlowReplayLogs(XfPage page, FlowReplayLog flowReplayLog) {
    return XfR.ok(flowReplayLogServiceImpl.page(page, Wrappers.query(flowReplayLog)));
  }

  /**
   * 通过id查询流程回放日志
   * @param  id
   * @return XfR
   */
  @GetMapping("/flowreplaylogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(flowReplayLogServiceImpl.getById(id));
  }

  /**
   * 新增流程回放日志
   * @param flowReplayLog 流程回放日志
   * @return XfR
   */
  @PostMapping("/flowreplaylogs")
  public XfR save(@RequestBody FlowReplayLog flowReplayLog) {
     return XfR.ok(flowReplayLogServiceImpl.save(flowReplayLog));
  }

  /**
   * 修改-传入修改后的全部数据流程回放日志
   * @param flowReplayLog 流程回放日志
   * @return XfR
   */
  @PutMapping("/flowreplaylogs/{id}")
  public XfR putUpdate(@RequestBody FlowReplayLog flowReplayLog,@PathVariable Long id) {
      flowReplayLog.setId(id);
      return XfR.ok(flowReplayLogServiceImpl.updateById(flowReplayLog));
  }

  /**
   * 修改-传入修改的数据流程回放日志
   * @param flowReplayLog 流程回放日志
   * @return XfR
   */
  @PatchMapping("/flowreplaylogs/{id}")
  public XfR patchUpdate(@RequestBody FlowReplayLog flowReplayLog,@PathVariable Long id) {
      FlowReplayLog upflowReplayLog = flowReplayLogServiceImpl.getById(id);
      if(upflowReplayLog != null){
        upflowReplayLog = ObjectCopyUtils.copyProperties(flowReplayLog,upflowReplayLog,true);
      }
      return XfR.ok(flowReplayLogServiceImpl.updateById(upflowReplayLog));
  }

  /**
   * 通过id删除流程回放日志
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/flowreplaylogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(flowReplayLogServiceImpl.removeById(id));
  }

  @PostMapping("/flowreplaylogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "flow_replay_log");
     params.put("request", condition);

     return XfR.ok(flowReplayLogServiceImpl.querys(params));
  }

}
