package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.Voucher;
import com.xforceplus.ultraman.app.arterydocument.service.IVoucherService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-28
 */
@RestController
public class VoucherController {

  @Autowired
  private IVoucherService voucherServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param voucher ${table.comment}
   * @return
   */
  @GetMapping("/vouchers" )
  public XfR getVouchers(XfPage page, Voucher voucher) {
    return XfR.ok(voucherServiceImpl.page(page, Wrappers.query(voucher)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/vouchers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(voucherServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param voucher ${table.comment}
   * @return XfR
   */
  @PostMapping("/vouchers")
  public XfR save(@RequestBody Voucher voucher) {
     return XfR.ok(voucherServiceImpl.save(voucher));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param voucher ${table.comment}
   * @return XfR
   */
  @PutMapping("/vouchers/{id}")
  public XfR putUpdate(@RequestBody Voucher voucher,@PathVariable Long id) {
      voucher.setId(id);
      return XfR.ok(voucherServiceImpl.updateById(voucher));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param voucher ${table.comment}
   * @return XfR
   */
  @PatchMapping("/vouchers/{id}")
  public XfR patchUpdate(@RequestBody Voucher voucher,@PathVariable Long id) {
      Voucher upvoucher = voucherServiceImpl.getById(id);
      if(upvoucher != null){
        upvoucher = ObjectCopyUtils.copyProperties(voucher,upvoucher,true);
      }
      return XfR.ok(voucherServiceImpl.updateById(upvoucher));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/vouchers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(voucherServiceImpl.removeById(id));
  }

  @PostMapping("/vouchers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "voucher");
     params.put("request", condition);

     return XfR.ok(voucherServiceImpl.querys(params));
  }

}
