package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.UltramanSysBoUserSetting;
import com.xforceplus.ultraman.app.arterydocument.service.IUltramanSysBoUserSettingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 页面用户自定义配置前端控制器
 *
 * @author ultraman
 * @date 2024-01-15
 */
@RestController
public class UltramanSysBoUserSettingController {

  @Autowired
  private IUltramanSysBoUserSettingService ultramanSysBoUserSettingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ultramanSysBoUserSetting 页面用户自定义配置
   * @return
   */
  @GetMapping("/ultramansysbousersettings" )
  public XfR getUltramanSysBoUserSettings(XfPage page, UltramanSysBoUserSetting ultramanSysBoUserSetting) {
    return XfR.ok(ultramanSysBoUserSettingServiceImpl.page(page, Wrappers.query(ultramanSysBoUserSetting)));
  }

  /**
   * 通过id查询页面用户自定义配置
   * @param  id
   * @return XfR
   */
  @GetMapping("/ultramansysbousersettings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ultramanSysBoUserSettingServiceImpl.getById(id));
  }

  /**
   * 新增页面用户自定义配置
   * @param ultramanSysBoUserSetting 页面用户自定义配置
   * @return XfR
   */
  @PostMapping("/ultramansysbousersettings")
  public XfR save(@RequestBody UltramanSysBoUserSetting ultramanSysBoUserSetting) {
     return XfR.ok(ultramanSysBoUserSettingServiceImpl.save(ultramanSysBoUserSetting));
  }

  /**
   * 修改-传入修改后的全部数据页面用户自定义配置
   * @param ultramanSysBoUserSetting 页面用户自定义配置
   * @return XfR
   */
  @PutMapping("/ultramansysbousersettings/{id}")
  public XfR putUpdate(@RequestBody UltramanSysBoUserSetting ultramanSysBoUserSetting,@PathVariable Long id) {
      ultramanSysBoUserSetting.setId(id);
      return XfR.ok(ultramanSysBoUserSettingServiceImpl.updateById(ultramanSysBoUserSetting));
  }

  /**
   * 修改-传入修改的数据页面用户自定义配置
   * @param ultramanSysBoUserSetting 页面用户自定义配置
   * @return XfR
   */
  @PatchMapping("/ultramansysbousersettings/{id}")
  public XfR patchUpdate(@RequestBody UltramanSysBoUserSetting ultramanSysBoUserSetting,@PathVariable Long id) {
      UltramanSysBoUserSetting upultramanSysBoUserSetting = ultramanSysBoUserSettingServiceImpl.getById(id);
      if(upultramanSysBoUserSetting != null){
        upultramanSysBoUserSetting = ObjectCopyUtils.copyProperties(ultramanSysBoUserSetting,upultramanSysBoUserSetting,true);
      }
      return XfR.ok(ultramanSysBoUserSettingServiceImpl.updateById(upultramanSysBoUserSetting));
  }

  /**
   * 通过id删除页面用户自定义配置
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ultramansysbousersettings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ultramanSysBoUserSettingServiceImpl.removeById(id));
  }

  @PostMapping("/ultramansysbousersettings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ultraman_sys_bo_user_setting");
     params.put("request", condition);

     return XfR.ok(ultramanSysBoUserSettingServiceImpl.querys(params));
  }

}
