package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.Payment;
import com.xforceplus.ultraman.app.arterydocument.service.IPaymentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-04
 */
@RestController
public class PaymentController {

  @Autowired
  private IPaymentService paymentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param payment ${table.comment}
   * @return
   */
  @GetMapping("/payments" )
  public XfR getPayments(XfPage page, Payment payment) {
    return XfR.ok(paymentServiceImpl.page(page, Wrappers.query(payment)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/payments/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(paymentServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param payment ${table.comment}
   * @return XfR
   */
  @PostMapping("/payments")
  public XfR save(@RequestBody Payment payment) {
     return XfR.ok(paymentServiceImpl.save(payment));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param payment ${table.comment}
   * @return XfR
   */
  @PutMapping("/payments/{id}")
  public XfR putUpdate(@RequestBody Payment payment,@PathVariable Long id) {
      payment.setId(id);
      return XfR.ok(paymentServiceImpl.updateById(payment));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param payment ${table.comment}
   * @return XfR
   */
  @PatchMapping("/payments/{id}")
  public XfR patchUpdate(@RequestBody Payment payment,@PathVariable Long id) {
      Payment uppayment = paymentServiceImpl.getById(id);
      if(uppayment != null){
        uppayment = ObjectCopyUtils.copyProperties(payment,uppayment,true);
      }
      return XfR.ok(paymentServiceImpl.updateById(uppayment));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/payments/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(paymentServiceImpl.removeById(id));
  }

  @PostMapping("/payments/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "payment");
     params.put("request", condition);

     return XfR.ok(paymentServiceImpl.querys(params));
  }

}
