package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.TabcodeMapping;
import com.xforceplus.ultraman.app.arterydocument.service.ITabcodeMappingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-04
 */
@RestController
public class TabcodeMappingController {

  @Autowired
  private ITabcodeMappingService tabcodeMappingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tabcodeMapping ${table.comment}
   * @return
   */
  @GetMapping("/tabcodemappings" )
  public XfR getTabcodeMappings(XfPage page, TabcodeMapping tabcodeMapping) {
    return XfR.ok(tabcodeMappingServiceImpl.page(page, Wrappers.query(tabcodeMapping)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tabcodemappings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tabcodeMappingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tabcodeMapping ${table.comment}
   * @return XfR
   */
  @PostMapping("/tabcodemappings")
  public XfR save(@RequestBody TabcodeMapping tabcodeMapping) {
     return XfR.ok(tabcodeMappingServiceImpl.save(tabcodeMapping));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tabcodeMapping ${table.comment}
   * @return XfR
   */
  @PutMapping("/tabcodemappings/{id}")
  public XfR putUpdate(@RequestBody TabcodeMapping tabcodeMapping,@PathVariable Long id) {
      tabcodeMapping.setId(id);
      return XfR.ok(tabcodeMappingServiceImpl.updateById(tabcodeMapping));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tabcodeMapping ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tabcodemappings/{id}")
  public XfR patchUpdate(@RequestBody TabcodeMapping tabcodeMapping,@PathVariable Long id) {
      TabcodeMapping uptabcodeMapping = tabcodeMappingServiceImpl.getById(id);
      if(uptabcodeMapping != null){
        uptabcodeMapping = ObjectCopyUtils.copyProperties(tabcodeMapping,uptabcodeMapping,true);
      }
      return XfR.ok(tabcodeMappingServiceImpl.updateById(uptabcodeMapping));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tabcodemappings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tabcodeMappingServiceImpl.removeById(id));
  }

  @PostMapping("/tabcodemappings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tabcode_mapping");
     params.put("request", condition);

     return XfR.ok(tabcodeMappingServiceImpl.querys(params));
  }

}
