package com.xforceplus.ultraman.app.autotest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.autotest.entity.Sanity;
import com.xforceplus.ultraman.app.autotest.service.ISanityService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-10
 */
@RestController
public class SanityController {

  @Autowired
  private ISanityService sanityServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sanity ${table.comment}
   * @return
   */
  @GetMapping("/sanitys" )
  public XfR getSanitys(XfPage page, Sanity sanity) {
    return XfR.ok(sanityServiceImpl.page(page, Wrappers.query(sanity)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/sanitys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sanityServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param sanity ${table.comment}
   * @return XfR
   */
  @PostMapping("/sanitys")
  public XfR save(@RequestBody Sanity sanity) {
     return XfR.ok(sanityServiceImpl.save(sanity));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param sanity ${table.comment}
   * @return XfR
   */
  @PutMapping("/sanitys/{id}")
  public XfR putUpdate(@RequestBody Sanity sanity,@PathVariable Long id) {
      sanity.setId(id);
      return XfR.ok(sanityServiceImpl.updateById(sanity));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param sanity ${table.comment}
   * @return XfR
   */
  @PatchMapping("/sanitys/{id}")
  public XfR patchUpdate(@RequestBody Sanity sanity,@PathVariable Long id) {
      Sanity upsanity = sanityServiceImpl.getById(id);
      if(upsanity != null){
        upsanity = ObjectCopyUtils.copyProperties(sanity,upsanity,true);
      }
      return XfR.ok(sanityServiceImpl.updateById(upsanity));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sanitys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sanityServiceImpl.removeById(id));
  }

  @PostMapping("/sanitys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sanity");
     params.put("request", condition);

     return XfR.ok(sanityServiceImpl.querys(params));
  }

}
