package com.xforceplus.ultraman.app.biassetmanagementservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * big_field_handle_type
 * </p>
 *
 * @author ultraman
 * @since 2024-05-15
 */
public enum BigFieldHandleType {

    _1("1", "上传s3"),
    _2("2", "忽略"),
    _1000("1000", "截取1千"),
    _10000("10000", "截取1万");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BigFieldHandleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BigFieldHandleType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "1000":
                return _1000;
            case "10000":
                return _10000;
            default:
                return null;
        }
    }
}
