package com.xforceplus.ultraman.app.biassetmanagementservice.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-05-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Database implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 数据库连接地址
   */
  private String url;

  /**
   * 数据库连接主机地址
   */
  private String host;

  /**
   * 数据库连接端口号
   */
  private Long port;

  /**
   * Jdbc驱动类
   */
  private String driverClass;

  /**
   * jdbc登录账号
   */
  private String username;

  /**
   * jdbc登录密码
   */
  private String password;

  /**
   * 云供应商
   */
  private String csp;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 实例名
   */
  private String instanceName;

  /**
   * devops资产标签
   */
  private String devopsAssetLabel;

  /**
   * 所属产线
   */
  private String productLine;

  /**
   * 数据库类型
   */
  private String databaseType;

  /**
   * 数据库方言类型
   */
  private String dialect;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("url", url);
      map.put("host", host);
      map.put("port", port);
      map.put("driver_class", driverClass);
      map.put("username", username);
      map.put("password", password);
      map.put("csp", csp);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("instance_name", instanceName);
      map.put("devops_asset_label", devopsAssetLabel);
      map.put("product_line", productLine);
      map.put("database_type", databaseType);
      map.put("dialect", dialect);

      return map;
  }

  public static Database fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Database entity = new Database();
    if(map.containsKey("url")) {
      Object obj = map.get("url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("host")) {
      Object obj = map.get("host");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHost((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("port")) {
      Object obj = map.get("port");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPort((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPort(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPort(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("driver_class")) {
      Object obj = map.get("driver_class");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDriverClass((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("username")) {
      Object obj = map.get("username");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUsername((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("password")) {
      Object obj = map.get("password");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPassword((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("csp")) {
      Object obj = map.get("csp");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCsp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("instance_name")) {
      Object obj = map.get("instance_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInstanceName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("devops_asset_label")) {
      Object obj = map.get("devops_asset_label");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDevopsAssetLabel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_line")) {
      Object obj = map.get("product_line");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductLine((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("database_type")) {
      Object obj = map.get("database_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDatabaseType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dialect")) {
      Object obj = map.get("dialect");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDialect((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("url")) {
      Object obj = map.get("url");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("host")) {
      Object obj = map.get("host");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHost((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("port")) {
      Object obj = map.get("port");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPort((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPort(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPort(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("driver_class")) {
      Object obj = map.get("driver_class");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDriverClass((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("username")) {
      Object obj = map.get("username");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUsername((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("password")) {
      Object obj = map.get("password");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPassword((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("csp")) {
      Object obj = map.get("csp");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCsp((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("instance_name")) {
      Object obj = map.get("instance_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInstanceName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("devops_asset_label")) {
      Object obj = map.get("devops_asset_label");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDevopsAssetLabel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("product_line")) {
      Object obj = map.get("product_line");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductLine((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("database_type")) {
      Object obj = map.get("database_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDatabaseType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dialect")) {
      Object obj = map.get("dialect");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDialect((String)obj);
        }
      } else {
      }
    }
  }
}
