package com.xforceplus.ultraman.app.biassetmanagementservice.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 三方平台账号系统对象
 * </p>
 *
 * @author ultraman
 * @since 2024-05-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SystemThirdPartyAccount implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 奥特曼账号id
   */
  private Long accountId;

  /**
   * 第三方平台账号id
   */
  private String thirdPartyId;

  /**
   * 第三方平台标识
   */
  private String thirdPartySource;

  /**
   * 第三方平台头像
   */
  private String thirdPartyAvatar;

  /**
   * 第三方登录token
   */
  private String thirdPartyAccessToken;

  /**
   * 第三方平台昵称
   */
  private String thirdPartyNickname;

  /**
   * 第三方平台用户名
   */
  private String thirdPartyUserName;

  /**
   * 第三方平台blog地址
   */
  private String thirdPartyBlog;

  /**
   * 第三方平台用户公司
   */
  private String thirdPartyCompany;

  /**
   * 第三方平台用户地址
   */
  private String thirdParthLocation;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 第三方平台用户邮箱
   */
  private String thirdPartyEmail;

  /**
   * 第三方平台用户手机
   */
  private String thirdPartyPhone;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("account_id", accountId);
      map.put("third_party_id", thirdPartyId);
      map.put("third_party_source", thirdPartySource);
      map.put("third_party_avatar", thirdPartyAvatar);
      map.put("third_party_access_token", thirdPartyAccessToken);
      map.put("third_party_nickname", thirdPartyNickname);
      map.put("third_party_user_name", thirdPartyUserName);
      map.put("third_party_blog", thirdPartyBlog);
      map.put("third_party_company", thirdPartyCompany);
      map.put("third_parth_location", thirdParthLocation);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("third_party_email", thirdPartyEmail);
      map.put("third_party_phone", thirdPartyPhone);

      return map;
  }

  public static SystemThirdPartyAccount fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SystemThirdPartyAccount entity = new SystemThirdPartyAccount();
    if(map.containsKey("account_id")) {
      Object obj = map.get("account_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAccountId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAccountId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("third_party_id")) {
      Object obj = map.get("third_party_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThirdPartyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("third_party_source")) {
      Object obj = map.get("third_party_source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThirdPartySource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("third_party_avatar")) {
      Object obj = map.get("third_party_avatar");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThirdPartyAvatar((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("third_party_access_token")) {
      Object obj = map.get("third_party_access_token");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThirdPartyAccessToken((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("third_party_nickname")) {
      Object obj = map.get("third_party_nickname");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThirdPartyNickname((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("third_party_user_name")) {
      Object obj = map.get("third_party_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThirdPartyUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("third_party_blog")) {
      Object obj = map.get("third_party_blog");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThirdPartyBlog((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("third_party_company")) {
      Object obj = map.get("third_party_company");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThirdPartyCompany((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("third_parth_location")) {
      Object obj = map.get("third_parth_location");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThirdParthLocation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("third_party_email")) {
      Object obj = map.get("third_party_email");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThirdPartyEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("third_party_phone")) {
      Object obj = map.get("third_party_phone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThirdPartyPhone((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("account_id")) {
      Object obj = map.get("account_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAccountId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAccountId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAccountId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("third_party_id")) {
      Object obj = map.get("third_party_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThirdPartyId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("third_party_source")) {
      Object obj = map.get("third_party_source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThirdPartySource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("third_party_avatar")) {
      Object obj = map.get("third_party_avatar");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThirdPartyAvatar((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("third_party_access_token")) {
      Object obj = map.get("third_party_access_token");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThirdPartyAccessToken((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("third_party_nickname")) {
      Object obj = map.get("third_party_nickname");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThirdPartyNickname((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("third_party_user_name")) {
      Object obj = map.get("third_party_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThirdPartyUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("third_party_blog")) {
      Object obj = map.get("third_party_blog");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThirdPartyBlog((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("third_party_company")) {
      Object obj = map.get("third_party_company");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThirdPartyCompany((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("third_parth_location")) {
      Object obj = map.get("third_parth_location");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThirdParthLocation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("third_party_email")) {
      Object obj = map.get("third_party_email");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThirdPartyEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("third_party_phone")) {
      Object obj = map.get("third_party_phone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThirdPartyPhone((String)obj);
        }
      } else {
      }
    }
  }
}
