package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * asset_type
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
public enum AssetType {

    _1("1", "贴源表"),
    _2("2", "贴源并表"),
    _3("3", "维度表"),
    _4("4", "事实模型"),
    _5("5", "中间模型"),
    _6("6", "汇总模型"),
    _7("7", "数据集市"),
    _0("0", "未分类"),
    _8("8", "临时表");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AssetType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AssetType fromCode(String code) {
        return Stream.of(AssetType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
