package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * big_field_handle_type
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
public enum BigFieldHandleType {

    _1("1", "上传s3"),
    _2("2", "忽略"),
    _1000("1000", "截取1千"),
    _10000("10000", "截取1万");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BigFieldHandleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BigFieldHandleType fromCode(String code) {
        return Stream.of(BigFieldHandleType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
