package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * check_range
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
public enum CheckRange {

    _1("1", "近一天"),
    _2("2", "近两天"),
    _3("3", "近三天"),
    _7("7", "近一周"),
    _30("30", "近一月"),
    _60("60", "近两月"),
    _90("90", "近三月"),
    _180("180", "近半年"),
    _360("360", "近一年"),
    _999("999", "全部");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CheckRange(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckRange fromCode(String code) {
        return Stream.of(CheckRange.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
