package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * data_sync_enable
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
public enum DataSyncEnable {

    _1("1", "启用"),
    _0("0", "不启用");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DataSyncEnable(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataSyncEnable fromCode(String code) {
        return Stream.of(DataSyncEnable.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
