package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * database_type
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
public enum DatabaseType {

    _1("1", "MySQL"),
    _2("2", "Postgresql"),
    _3("3", "Redshift"),
    _4("4", "Greenplum");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DatabaseType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DatabaseType fromCode(String code) {
        return Stream.of(DatabaseType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
