package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * delete_hand_type
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
public enum DeleteHandType {

    _1("1", "保留痕迹"),
    _2("2", "保留数据");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DeleteHandType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DeleteHandType fromCode(String code) {
        return Stream.of(DeleteHandType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
