package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dialect
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
public enum Dialect {

    _1("1", "MySQL"),
    _2("2", "Postgresql");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Dialect(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Dialect fromCode(String code) {
        return Stream.of(Dialect.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
