package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * enable_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
public enum EnableFlag {

    _1("1", "启用"),
    _0("0", "不启用");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EnableFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EnableFlag fromCode(String code) {
        return Stream.of(EnableFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
