package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * instance_used_status
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
public enum InstanceUsedStatus {

    _0("0", "待启用"),
    _1("1", "上线"),
    _2("2", "已下线"),
    _3("3", "待确定");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InstanceUsedStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InstanceUsedStatus fromCode(String code) {
        return Stream.of(InstanceUsedStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
