package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * model_task_status
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
public enum ModelTaskStatus {

    _1("1", "无效"),
    _2("2", "有效");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ModelTaskStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ModelTaskStatus fromCode(String code) {
        return Stream.of(ModelTaskStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
