package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * notice_channel
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
public enum NoticeChannel {

    _1("1", "钉钉"),
    _2("2", "邮件");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NoticeChannel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NoticeChannel fromCode(String code) {
        return Stream.of(NoticeChannel.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
