package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * origin_type
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
public enum OriginType {

    _1("1", "数据库预定义"),
    _2("2", "外部定义");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OriginType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OriginType fromCode(String code) {
        return Stream.of(OriginType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
