package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * product_line
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
public enum ProductLine {

    _1("1", "平台研发-用户中心"),
    _2("2", "进项-4.0"),
    _3("3", "进项-2.0/3.0"),
    _4("4", "销项-4.0"),
    _5("5", "销项-2.0/3.0"),
    _6("6", "协同"),
    _7("7", "Linkus"),
    _8("8", "数据增值"),
    _9("9", "devops"),
    _10("10", "税件"),
    _11("11", "HR"),
    _12("12", "财务"),
    _13("13", "平台研发-基础服务"),
    _14("14", "平台研发-门户"),
    _15("15", "平台研发-BI"),
    _16("16", "集成二开"),
    _17("17", "SA"),
    _18("18", "平台研发-集成平台");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProductLine(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProductLine fromCode(String code) {
        return Stream.of(ProductLine.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
