package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * run_status
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
public enum RunStatus {

    _1("1", "待执行"),
    _2("2", "执行中"),
    _3("3", "执行失败"),
    _4("4", "执行成功");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RunStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RunStatus fromCode(String code) {
        return Stream.of(RunStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
