package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * sync_task_exec_type
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
public enum SyncTaskExecType {

    _1("1", "手动"),
    _2("2", "自动");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SyncTaskExecType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SyncTaskExecType fromCode(String code) {
        return Stream.of(SyncTaskExecType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
