package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * model_task_info
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ModelTaskInfo implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 任务id
   */
  private Long jobId;
  /**
   * 任务名称
   */
  private String jobName;
  /**
   * 任务层级
   */
  private String jobNode;
  /**
   * 数据同步类型
   */
  private String jobType;
  /**
   * 结果名称
   */
  private String targetTableName;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 是否启用
   */
  private String isValid;
  /**
   * 是否自动调度
   */
  private Long isAutoSchedule;
  /**
   * 执行sql
   */
  private String jobSql;
  /**
   * 参数
   */
  private String argsRepSql;
  /**
   * 任务描述
   */
  private String jobDescribe;
  /**
   * cron
   */
  private String executeCronExpress;
  /**
   * 最近执行时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lastExecuteTime;
  /**
   * 任务状态
   */
  private String modelTaskStatus;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("job_id", jobId);
      map.put("job_name", jobName);
      map.put("job_node", jobNode);
      map.put("job_type", jobType);
      map.put("target_table_name", targetTableName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("is_valid", isValid);
      map.put("is_auto_schedule", isAutoSchedule);
      map.put("job_sql", jobSql);
      map.put("args_rep_sql", argsRepSql);
      map.put("job_describe", jobDescribe);
      map.put("execute_cron_express", executeCronExpress);
      map.put("lastExecuteTime", BocpGenUtils.toTimestamp(lastExecuteTime));
      map.put("model_task_status", modelTaskStatus);

      return map;
  }

  public static ModelTaskInfo fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    ModelTaskInfo entity = new ModelTaskInfo();

    if(map.containsKey("job_id")) {
      Object obj = map.get("job_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setJobId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJobId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setJobId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("job_name")) {
      Object obj = map.get("job_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJobName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("job_node")) {
      Object obj = map.get("job_node");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJobNode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("job_type")) {
      Object obj = map.get("job_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJobType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("target_table_name")) {
      Object obj = map.get("target_table_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTargetTableName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_valid")) {
      Object obj = map.get("is_valid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsValid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_auto_schedule")) {
      Object obj = map.get("is_auto_schedule");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIsAutoSchedule((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsAutoSchedule(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setIsAutoSchedule(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("job_sql")) {
      Object obj = map.get("job_sql");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJobSql((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("args_rep_sql")) {
      Object obj = map.get("args_rep_sql");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setArgsRepSql((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("job_describe")) {
      Object obj = map.get("job_describe");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJobDescribe((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("execute_cron_express")) {
      Object obj = map.get("execute_cron_express");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExecuteCronExpress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastExecuteTime")) {
      Object obj = map.get("lastExecuteTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLastExecuteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setLastExecuteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastExecuteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLastExecuteTime(null);
      }
    }
    if(map.containsKey("model_task_status")) {
      Object obj = map.get("model_task_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setModelTaskStatus((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("job_id")) {
      Object obj = map.get("job_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setJobId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setJobId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setJobId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("job_name")) {
      Object obj = map.get("job_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setJobName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("job_node")) {
      Object obj = map.get("job_node");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setJobNode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("job_type")) {
      Object obj = map.get("job_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setJobType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("target_table_name")) {
      Object obj = map.get("target_table_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTargetTableName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_valid")) {
      Object obj = map.get("is_valid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsValid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_auto_schedule")) {
      Object obj = map.get("is_auto_schedule");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setIsAutoSchedule((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIsAutoSchedule(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setIsAutoSchedule(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("job_sql")) {
      Object obj = map.get("job_sql");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setJobSql((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("args_rep_sql")) {
      Object obj = map.get("args_rep_sql");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setArgsRepSql((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("job_describe")) {
      Object obj = map.get("job_describe");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setJobDescribe((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("execute_cron_express")) {
      Object obj = map.get("execute_cron_express");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExecuteCronExpress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastExecuteTime")) {
      Object obj = map.get("lastExecuteTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setLastExecuteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setLastExecuteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLastExecuteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setLastExecuteTime(null);
      }
    }
    if(map.containsKey("model_task_status")) {
      Object obj = map.get("model_task_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setModelTaskStatus((String)obj);
        }
      } else{
      }
    }
  }
}
