package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * sync_db_data_to_redshift_tasklog
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SyncDbDataToRedshiftTasklog implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 同步数据量
   */
  private Long syncCount;
  /**
   * 同步开始时间
   */
  private String syncStartTime;
  /**
   * 同步结束时间
   */
  private String syncEndTime;
  /**
   * 主机名
   */
  private String syncHostName;
  /**
   * 主机ip
   */
  private String syncHostIp;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 同步任务状态
   */
  private String syncTaskStatus;
  /**
   * 备注
   */
  private String syncTaskMemo;
  /**
   * 执行方式
   */
  private String syncTaskExecType;
  /**
   * 计划开始时间
   */
  private String planStartTime;
  /**
   * 执行节点id
   */
  private String podId;

  /**
   * 对一关联关系 关联对象 syncDbDataToRedshiftTask
   */
  private Long syncTaskRecordId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("sync_count", syncCount);
      map.put("sync_start_time", syncStartTime);
      map.put("sync_end_time", syncEndTime);
      map.put("sync_host_name", syncHostName);
      map.put("sync_host_ip", syncHostIp);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("sync_task_status", syncTaskStatus);
      map.put("sync_task_memo", syncTaskMemo);
      map.put("sync_task_exec_type", syncTaskExecType);
      map.put("plan_start_time", planStartTime);
      map.put("pod_id", podId);

      map.put("syncTaskRecord.id", syncTaskRecordId);
      return map;
  }

  public static SyncDbDataToRedshiftTasklog fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    SyncDbDataToRedshiftTasklog entity = new SyncDbDataToRedshiftTasklog();

    if(map.containsKey("sync_count")) {
      Object obj = map.get("sync_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSyncCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSyncCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSyncCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sync_start_time")) {
      Object obj = map.get("sync_start_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSyncStartTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_end_time")) {
      Object obj = map.get("sync_end_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSyncEndTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_host_name")) {
      Object obj = map.get("sync_host_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSyncHostName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_host_ip")) {
      Object obj = map.get("sync_host_ip");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSyncHostIp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_task_status")) {
      Object obj = map.get("sync_task_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSyncTaskStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_task_memo")) {
      Object obj = map.get("sync_task_memo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSyncTaskMemo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_task_exec_type")) {
      Object obj = map.get("sync_task_exec_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSyncTaskExecType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plan_start_time")) {
      Object obj = map.get("plan_start_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlanStartTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pod_id")) {
      Object obj = map.get("pod_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPodId((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("syncTaskRecord.id")) {
       Object obj = map.get("syncTaskRecord.id");
       if(obj instanceof Long) {
         entity.setSyncTaskRecordId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setSyncTaskRecordId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("sync_count")) {
      Object obj = map.get("sync_count");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSyncCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSyncCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSyncCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sync_start_time")) {
      Object obj = map.get("sync_start_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSyncStartTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_end_time")) {
      Object obj = map.get("sync_end_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSyncEndTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_host_name")) {
      Object obj = map.get("sync_host_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSyncHostName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_host_ip")) {
      Object obj = map.get("sync_host_ip");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSyncHostIp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_task_status")) {
      Object obj = map.get("sync_task_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSyncTaskStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_task_memo")) {
      Object obj = map.get("sync_task_memo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSyncTaskMemo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_task_exec_type")) {
      Object obj = map.get("sync_task_exec_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSyncTaskExecType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plan_start_time")) {
      Object obj = map.get("plan_start_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPlanStartTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pod_id")) {
      Object obj = map.get("pod_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPodId((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("syncTaskRecord.id")) {
    Object obj = map.get("syncTaskRecord.id");
    if(obj instanceof Long) {
        this.setSyncTaskRecordId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setSyncTaskRecordId(Long.parseLong((String)obj));
    }
  }
  }
}
