package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.validator;

import com.xforceplus.ultraman.app.biassetmanagementservice.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = null != OrgType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = null != CreationMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = null != OrgStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DatabaseType.class)) {
            isValid = null != DatabaseType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DatabaseType.class.getSimpleName());
            }
        }
        if(clazz.equals(AssetType.class)) {
            isValid = null != AssetType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AssetType.class.getSimpleName());
            }
        }
        if(clazz.equals(Dialect.class)) {
            isValid = null != Dialect.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Dialect.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSyncType.class)) {
            isValid = null != DataSyncType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataSyncType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSyncEnable.class)) {
            isValid = null != DataSyncEnable.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataSyncEnable.class.getSimpleName());
            }
        }
        if(clazz.equals(BigFieldHandleType.class)) {
            isValid = null != BigFieldHandleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BigFieldHandleType.class.getSimpleName());
            }
        }
        if(clazz.equals(SyncTaskStatus.class)) {
            isValid = null != SyncTaskStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SyncTaskStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SyncTaskExecType.class)) {
            isValid = null != SyncTaskExecType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SyncTaskExecType.class.getSimpleName());
            }
        }
        if(clazz.equals(NodeHeathStatus.class)) {
            isValid = null != NodeHeathStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NodeHeathStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ProductLine.class)) {
            isValid = null != ProductLine.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProductLine.class.getSimpleName());
            }
        }
        if(clazz.equals(NoticeChannel.class)) {
            isValid = null != NoticeChannel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoticeChannel.class.getSimpleName());
            }
        }
        if(clazz.equals(EnableFlag.class)) {
            isValid = null != EnableFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EnableFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(RunStatus.class)) {
            isValid = null != RunStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RunStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ModelTaskStatus.class)) {
            isValid = null != ModelTaskStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ModelTaskStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DeleteHandType.class)) {
            isValid = null != DeleteHandType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DeleteHandType.class.getSimpleName());
            }
        }
        if(clazz.equals(InstanceUsedStatus.class)) {
            isValid = null != InstanceUsedStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InstanceUsedStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OriginType.class)) {
            isValid = null != OriginType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OriginType.class.getSimpleName());
            }
        }
        if(clazz.equals(YesOrNo.class)) {
            isValid = null != YesOrNo.fromCode(value);
            if(!isValid) {
                unValidMsg(context, YesOrNo.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckRange.class)) {
            isValid = null != CheckRange.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CheckRange.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
