package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.validator;

import com.xforceplus.ultraman.app.biassetmanagementservice.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-06-14
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrgType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CreationMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrgStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DatabaseType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DatabaseType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DatabaseType.class.getSimpleName());
            }
        }
        if(clazz.equals(AssetType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AssetType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AssetType.class.getSimpleName());
            }
        }
        if(clazz.equals(Dialect.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Dialect.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Dialect.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSyncType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataSyncType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataSyncType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSyncEnable.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataSyncEnable.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataSyncEnable.class.getSimpleName());
            }
        }
        if(clazz.equals(BigFieldHandleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BigFieldHandleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BigFieldHandleType.class.getSimpleName());
            }
        }
        if(clazz.equals(SyncTaskStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SyncTaskStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SyncTaskStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SyncTaskExecType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SyncTaskExecType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SyncTaskExecType.class.getSimpleName());
            }
        }
        if(clazz.equals(NodeHeathStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NodeHeathStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NodeHeathStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ProductLine.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProductLine.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProductLine.class.getSimpleName());
            }
        }
        if(clazz.equals(NoticeChannel.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NoticeChannel.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NoticeChannel.class.getSimpleName());
            }
        }
        if(clazz.equals(EnableFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EnableFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EnableFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(RunStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RunStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RunStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ModelTaskStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ModelTaskStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ModelTaskStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DeleteHandType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DeleteHandType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DeleteHandType.class.getSimpleName());
            }
        }
        if(clazz.equals(InstanceUsedStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InstanceUsedStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InstanceUsedStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OriginType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OriginType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OriginType.class.getSimpleName());
            }
        }
        if(clazz.equals(YesOrNo.class)) {
            isValid = vals.stream()
                    .filter(val -> null != YesOrNo.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, YesOrNo.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckRange.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CheckRange.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CheckRange.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
