package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * data_sync_type
 * </p>
 *
 * @author ultraman
 * @since 2024-05-14
 */
public enum DataSyncType {

    _1("1", "离线-全量"),
    _2("2", "离线-增量"),
    _3("3", "实时");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DataSyncType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataSyncType fromCode(String code) {
        return Stream.of(DataSyncType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
