package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * sync_task_status
 * </p>
 *
 * @author ultraman
 * @since 2024-05-14
 */
public enum SyncTaskStatus {

    _1("1", "待处理"),
    _2("2", "同步中"),
    _3("3", "同步成功"),
    _4("4", "同步失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SyncTaskStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SyncTaskStatus fromCode(String code) {
        return Stream.of(SyncTaskStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
