package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * sync_db_data_to_redshift_task
 * </p>
 *
 * @author ultraman
 * @since 2024-05-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SyncDbDataToRedshiftTask implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 数据同步类型
   */
  private String dataSyncType;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 数据同步是否启用
   */
  private String dataSyncEnable;
  /**
   * 大字段处理策略
   */
  private String bigFieldHandleType;
  /**
   * 同步条件
   */
  private String syncSqlWhere;
  /**
   * 实时同步topic名称
   */
  private String kafkaTopicName;
  /**
   * 实时同步topic分区
   */
  private Long kafkaTopicPartition;
  /**
   * 实时同步起始位置
   */
  private String kafkaTopicStartOffset;
  /**
   * 本次同步数据条数
   */
  private String syncDataCurSize;
  /**
   * 总共同步数据条数
   */
  private String syncDataTotalSize;
  /**
   * 离线同步使用的排序字段
   */
  private String incrementKey;
  /**
   * 上次离线同步的最后位置
   */
  private String lastSyncIncrementKeyValue;
  /**
   * 离线同步cron表达式
   */
  private String syncCronExpress;
  /**
   * 最近同步开始时间
   */
  private String lastSyncStartTime;
  /**
   * 最近同步结束时间
   */
  private String lastSyncEndTime;
  /**
   * 下次开始同步时间
   */
  private String nextSyncStartTime;

  /**
   * 对一关联关系 关联对象 asset
   */
  private Long syncTargetTableId;
  /**
   * 对一关联关系 关联对象 table
   */
  private Long syncSourceTableId;
  /**
   * 对一关联关系 关联对象 database
   */
  private Long databaseToSyncTaskId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("data_sync_type", dataSyncType);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("data_sync_enable", dataSyncEnable);
      map.put("big_field_handle_type", bigFieldHandleType);
      map.put("sync_sql_where", syncSqlWhere);
      map.put("kafka_topic_name", kafkaTopicName);
      map.put("kafka_topic_partition", kafkaTopicPartition);
      map.put("kafka_topic_start_offset", kafkaTopicStartOffset);
      map.put("sync_data_cur_size", syncDataCurSize);
      map.put("sync_data_total_size", syncDataTotalSize);
      map.put("increment_key", incrementKey);
      map.put("last_sync_increment_key_value", lastSyncIncrementKeyValue);
      map.put("sync_cron_express", syncCronExpress);
      map.put("last_sync_start_time", lastSyncStartTime);
      map.put("last_sync_end_time", lastSyncEndTime);
      map.put("next_sync_start_time", nextSyncStartTime);

      map.put("syncTargetTable.id", syncTargetTableId);
      map.put("syncSourceTable.id", syncSourceTableId);
      map.put("databaseToSyncTask.id", databaseToSyncTaskId);
      return map;
  }

  public static SyncDbDataToRedshiftTask fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    SyncDbDataToRedshiftTask entity = new SyncDbDataToRedshiftTask();

    if(map.containsKey("data_sync_type")) {
      Object obj = map.get("data_sync_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataSyncType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("data_sync_enable")) {
      Object obj = map.get("data_sync_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataSyncEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("big_field_handle_type")) {
      Object obj = map.get("big_field_handle_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBigFieldHandleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_sql_where")) {
      Object obj = map.get("sync_sql_where");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSyncSqlWhere((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kafka_topic_name")) {
      Object obj = map.get("kafka_topic_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKafkaTopicName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kafka_topic_partition")) {
      Object obj = map.get("kafka_topic_partition");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setKafkaTopicPartition((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setKafkaTopicPartition(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setKafkaTopicPartition(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("kafka_topic_start_offset")) {
      Object obj = map.get("kafka_topic_start_offset");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKafkaTopicStartOffset((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_data_cur_size")) {
      Object obj = map.get("sync_data_cur_size");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSyncDataCurSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_data_total_size")) {
      Object obj = map.get("sync_data_total_size");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSyncDataTotalSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("increment_key")) {
      Object obj = map.get("increment_key");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIncrementKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("last_sync_increment_key_value")) {
      Object obj = map.get("last_sync_increment_key_value");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLastSyncIncrementKeyValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_cron_express")) {
      Object obj = map.get("sync_cron_express");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSyncCronExpress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("last_sync_start_time")) {
      Object obj = map.get("last_sync_start_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLastSyncStartTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("last_sync_end_time")) {
      Object obj = map.get("last_sync_end_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLastSyncEndTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("next_sync_start_time")) {
      Object obj = map.get("next_sync_start_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNextSyncStartTime((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("syncTargetTable.id")) {
       Object obj = map.get("syncTargetTable.id");
       if(obj instanceof Long) {
         entity.setSyncTargetTableId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setSyncTargetTableId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("syncSourceTable.id")) {
       Object obj = map.get("syncSourceTable.id");
       if(obj instanceof Long) {
         entity.setSyncSourceTableId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setSyncSourceTableId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("databaseToSyncTask.id")) {
       Object obj = map.get("databaseToSyncTask.id");
       if(obj instanceof Long) {
         entity.setDatabaseToSyncTaskId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setDatabaseToSyncTaskId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("data_sync_type")) {
      Object obj = map.get("data_sync_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDataSyncType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("data_sync_enable")) {
      Object obj = map.get("data_sync_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDataSyncEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("big_field_handle_type")) {
      Object obj = map.get("big_field_handle_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBigFieldHandleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_sql_where")) {
      Object obj = map.get("sync_sql_where");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSyncSqlWhere((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kafka_topic_name")) {
      Object obj = map.get("kafka_topic_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setKafkaTopicName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kafka_topic_partition")) {
      Object obj = map.get("kafka_topic_partition");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setKafkaTopicPartition((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setKafkaTopicPartition(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setKafkaTopicPartition(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("kafka_topic_start_offset")) {
      Object obj = map.get("kafka_topic_start_offset");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setKafkaTopicStartOffset((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_data_cur_size")) {
      Object obj = map.get("sync_data_cur_size");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSyncDataCurSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_data_total_size")) {
      Object obj = map.get("sync_data_total_size");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSyncDataTotalSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("increment_key")) {
      Object obj = map.get("increment_key");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIncrementKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("last_sync_increment_key_value")) {
      Object obj = map.get("last_sync_increment_key_value");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLastSyncIncrementKeyValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_cron_express")) {
      Object obj = map.get("sync_cron_express");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSyncCronExpress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("last_sync_start_time")) {
      Object obj = map.get("last_sync_start_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLastSyncStartTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("last_sync_end_time")) {
      Object obj = map.get("last_sync_end_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLastSyncEndTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("next_sync_start_time")) {
      Object obj = map.get("next_sync_start_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNextSyncStartTime((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("syncTargetTable.id")) {
    Object obj = map.get("syncTargetTable.id");
    if(obj instanceof Long) {
        this.setSyncTargetTableId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setSyncTargetTableId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("syncSourceTable.id")) {
    Object obj = map.get("syncSourceTable.id");
    if(obj instanceof Long) {
        this.setSyncSourceTableId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setSyncSourceTableId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("databaseToSyncTask.id")) {
    Object obj = map.get("databaseToSyncTask.id");
    if(obj instanceof Long) {
        this.setDatabaseToSyncTaskId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setDatabaseToSyncTaskId(Long.parseLong((String)obj));
    }
  }
  }
}
