package com.xforceplus.ultraman.app.biassetmanagementservice.metadata.validator;

import com.xforceplus.ultraman.app.biassetmanagementservice.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.biassetmanagementservice.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-05-14
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = null != OrgType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = null != CreationMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = null != OrgStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DatabaseType.class)) {
            isValid = null != DatabaseType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DatabaseType.class.getSimpleName());
            }
        }
        if(clazz.equals(AssetType.class)) {
            isValid = null != AssetType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AssetType.class.getSimpleName());
            }
        }
        if(clazz.equals(Dialect.class)) {
            isValid = null != Dialect.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Dialect.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSyncType.class)) {
            isValid = null != DataSyncType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataSyncType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSyncEnable.class)) {
            isValid = null != DataSyncEnable.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataSyncEnable.class.getSimpleName());
            }
        }
        if(clazz.equals(BigFieldHandleType.class)) {
            isValid = null != BigFieldHandleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BigFieldHandleType.class.getSimpleName());
            }
        }
        if(clazz.equals(SyncTaskStatus.class)) {
            isValid = null != SyncTaskStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SyncTaskStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
