package com.xforceplus.ultraman.app.biassetmanagementservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.biassetmanagementservice.entity.AssetMapping;
import com.xforceplus.ultraman.app.biassetmanagementservice.service.IAssetMappingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-08
 */
@RestController
public class AssetMappingController {

  @Autowired
  private IAssetMappingService assetMappingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param assetMapping ${table.comment}
   * @return
   */
  @GetMapping("/assetmappings" )
  public XfR getAssetMappings(XfPage page, AssetMapping assetMapping) {
    return XfR.ok(assetMappingServiceImpl.page(page, Wrappers.query(assetMapping)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/assetmappings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(assetMappingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param assetMapping ${table.comment}
   * @return XfR
   */
  @PostMapping("/assetmappings")
  public XfR save(@RequestBody AssetMapping assetMapping) {
     return XfR.ok(assetMappingServiceImpl.save(assetMapping));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param assetMapping ${table.comment}
   * @return XfR
   */
  @PutMapping("/assetmappings/{id}")
  public XfR putUpdate(@RequestBody AssetMapping assetMapping,@PathVariable Long id) {
      assetMapping.setId(id);
      return XfR.ok(assetMappingServiceImpl.updateById(assetMapping));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param assetMapping ${table.comment}
   * @return XfR
   */
  @PatchMapping("/assetmappings/{id}")
  public XfR patchUpdate(@RequestBody AssetMapping assetMapping,@PathVariable Long id) {
      AssetMapping upassetMapping = assetMappingServiceImpl.getById(id);
      if(upassetMapping != null){
        upassetMapping = ObjectCopyUtils.copyProperties(assetMapping,upassetMapping,true);
      }
      return XfR.ok(assetMappingServiceImpl.updateById(upassetMapping));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/assetmappings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(assetMappingServiceImpl.removeById(id));
  }

  @PostMapping("/assetmappings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "asset_mapping");
     params.put("request", condition);

     return XfR.ok(assetMappingServiceImpl.querys(params));
  }

}
