package com.xforceplus.ultraman.app.biassetmanagementservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.biassetmanagementservice.entity.Database;
import com.xforceplus.ultraman.app.biassetmanagementservice.service.IDatabaseService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-08
 */
@RestController
public class DatabaseController {

  @Autowired
  private IDatabaseService databaseServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param database ${table.comment}
   * @return
   */
  @GetMapping("/databases" )
  public XfR getDatabases(XfPage page, Database database) {
    return XfR.ok(databaseServiceImpl.page(page, Wrappers.query(database)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/databases/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(databaseServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param database ${table.comment}
   * @return XfR
   */
  @PostMapping("/databases")
  public XfR save(@RequestBody Database database) {
     return XfR.ok(databaseServiceImpl.save(database));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param database ${table.comment}
   * @return XfR
   */
  @PutMapping("/databases/{id}")
  public XfR putUpdate(@RequestBody Database database,@PathVariable Long id) {
      database.setId(id);
      return XfR.ok(databaseServiceImpl.updateById(database));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param database ${table.comment}
   * @return XfR
   */
  @PatchMapping("/databases/{id}")
  public XfR patchUpdate(@RequestBody Database database,@PathVariable Long id) {
      Database updatabase = databaseServiceImpl.getById(id);
      if(updatabase != null){
        updatabase = ObjectCopyUtils.copyProperties(database,updatabase,true);
      }
      return XfR.ok(databaseServiceImpl.updateById(updatabase));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/databases/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(databaseServiceImpl.removeById(id));
  }

  @PostMapping("/databases/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "database");
     params.put("request", condition);

     return XfR.ok(databaseServiceImpl.querys(params));
  }

}
